/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.handler;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.IMPConfig;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.client.gui.components.MusicVolumeSlider;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.imp.client.music.MusicSyncManager;
import dev.felnull.imp.client.renderer.item.IMPItemRenderers;
import dev.felnull.imp.client.renderer.item.hand.BoomboxHandRenderer;
import dev.felnull.imp.entity.IRingerPartyParrot;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import dev.felnull.otyacraftengine.client.event.ClientEvent;
import dev.felnull.otyacraftengine.client.event.FabricOBJLoaderEvent;
import dev.felnull.otyacraftengine.client.gui.TextureSpecifyLocation;
import dev.felnull.otyacraftengine.client.gui.components.IconButton;
import dev.felnull.otyacraftengine.event.MoreEntityEvent;
import dev.felnull.otyacraftengine.item.location.HandItemLocation;
import dev.felnull.otyacraftengine.item.location.IPlayerItemLocation;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_443;
import net.minecraft.class_572;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

public class ClientHandler {
    private static final class_310 mc = class_310.method_1551();

    public static void init() {
        FabricOBJLoaderEvent.LOAD.register(ClientHandler::objLoad);
        ClientLifecycleEvent.CLIENT_LEVEL_LOAD.register(ClientHandler::onClientLevelLoad);
        ClientEvent.CHANGE_HAND_HEIGHT.register(ClientHandler::changeHandHeight);
        ClientGuiEvent.INIT_POST.register(ClientHandler::onScreenInit);
        AutoConfig.getConfigHolder(IamMusicPlayer.CONFIG.getClass()).registerSaveListener(ClientHandler::onConfigSave);
        ClientEvent.POSE_HUMANOID_ARM.register(ClientHandler::onPoseHumanoidArm);
        ClientEvent.INTEGRATED_SERVER_PAUSE.register(ClientHandler::onPauseChange);
        MoreEntityEvent.ENTITY_TICK.register(ClientHandler::onEntityTick);
        ClientTickEvent.CLIENT_POST.register(ClientHandler::ontClientTick);
        ClientEvent.HAND_ATTACK.register(ClientHandler::onHandAttack);
    }

    private static EventResult onHandAttack(@NotNull class_1799 itemStack) {
        if (itemStack.method_7909() instanceof BoomboxItem && BoomboxItem.isPowerOn(itemStack)) {
            UUID bu;
            if (ClientHandler.mc.field_1724.method_18276() && (bu = BoomboxItem.getUUID(itemStack)) != null) {
                NetworkManager.sendToServer((class_2960)IMPPackets.HAND_LID_CYCLE, (class_2540)new IMPPackets.LidCycleMessage(bu, (IPlayerItemLocation)new HandItemLocation(class_1268.field_5808)).toFBB());
            }
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static EventResult onEntityTick(class_1297 entity) {
        IRingerPartyParrot ringerPartyParrot;
        UUID id;
        if (!entity.field_6002.method_8608()) {
            return EventResult.pass();
        }
        MusicEngine mm = MusicEngine.getInstance();
        if (entity instanceof IRingerPartyParrot && ((id = (ringerPartyParrot = (IRingerPartyParrot)entity).getRingerUUID()) == null || !mm.isPlaying(id))) {
            ringerPartyParrot.setRingerUUID(null);
        }
        return EventResult.pass();
    }

    private static void onPauseChange(boolean paused) {
        MusicRingManager rm = MusicRingManager.getInstance();
        MusicEngine mm = MusicEngine.getInstance();
        if (paused) {
            rm.pause();
            mm.pause();
        } else {
            rm.resume();
            mm.resume();
        }
    }

    private static class_1269 onConfigSave(ConfigHolder<IMPConfig> configHolder, IMPConfig impConfig) {
        MusicEngine.getInstance().reload();
        return class_1269.field_5812;
    }

    private static EventResult objLoad(class_2960 resourceLocation) {
        if ("iammusicplayer".equals(resourceLocation.method_12836())) {
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    private static void onClientLevelLoad(class_638 clientLevel) {
        MusicSyncManager.getInstance().reset();
    }

    private static EventResult changeHandHeight(class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        if (oldStack.method_7909() instanceof BoomboxItem && newStack.method_7909() instanceof BoomboxItem && BoomboxItem.matches(oldStack, newStack)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static void onScreenInit(class_437 screen, ScreenAccess screenAccess) {
        if (screen instanceof class_443) {
            int i = 11;
            int x = screen.field_22789 / 2 - 155 + i % 2 * 160;
            int y = screen.field_22790 / 6 - 12 + 22 * (i >> 1);
            screenAccess.addRenderableWidget((class_339)new MusicVolumeSlider(x, y, 150));
            screenAccess.addRenderableWidget((class_339)new IconButton(x + 150 + 4, y, 20, 20, (class_2561)new class_2588("imp.button.config"), new TextureSpecifyLocation(MusicManagerMonitor.WIDGETS_TEXTURE, 36, 58, 14, 5), n -> mc.method_1507((class_437)AutoConfig.getConfigScreen(IMPConfig.class, (class_437)screen).get())));
        }
    }

    private static EventResult onPoseHumanoidArm(class_1306 arm, class_1268 hand, class_572<? extends class_1309> model, class_1309 livingEntity) {
        class_1799 item = livingEntity.method_5998(hand);
        if (item.method_31574(((class_2248)IMPBlocks.BOOMBOX.get()).method_8389()) && (float)BoomboxItem.getTransferProgress(item) >= 1.0f) {
            BoomboxHandRenderer.pose(arm, model, item);
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private static void ontClientTick(class_310 instance) {
        if (IMPItemRenderers.manualItemRenderer != null) {
            IMPItemRenderers.manualItemRenderer.tick();
        }
    }
}

